'=============================================================
'                      Terms of License
' -----------------------------------------------------------
' Terminabrechnung  2024 by Jens-Christian Wawrczeck
' is licensed under *CC BY-SA 4.0*
' (Creative Commons Attribution-ShareAlike 4.0 International)
' -----------------------------------------------------------
' To view a copy of this license, visit
' https://creativecommons.org/licenses/by-sa/4.0/
'=============================================================

Option Compare Database
Option Explicit

Private Sub Form_Current()
    'berschriften eintragen
    If Trim(km_TabellenKuerzel) <> "" Then Me.km_Bezeichnungsfeld.Caption = km_TabellenKuerzel
    
    Me.Dauer_Minuten.Visible = False
    Me.Dauer_Std.Visible = False
    Me.Dauer_StdMin.Visible = False
    Me.Summe_Dauer_Minuten.Visible = False
    Me.Summe_Dauer_Std.Visible = False
    Me.Summe_Dauer_StdMin.Visible = False
    
    Select Case FormatTermindauer
        Case 0      'Minuten  (Bsp.: 105)
            Me.Dauer_Bezeichnungsfeld.Caption = "Minuten"
            Me.Dauer_Minuten.Visible = True
            Me.Summe_Dauer_Minuten.Visible = True
        Case 4      'Dezimalstunden  (1,75)
            Me.Dauer_Bezeichnungsfeld.Caption = "Std"
            Me.Dauer_Std.Visible = True
            Me.Summe_Dauer_Std.Visible = True
        Case 8      'Std:Min  (01:45)
            Me.Dauer_Bezeichnungsfeld.Caption = "Std:Min"
            Me.Dauer_StdMin.Visible = True
            Me.Summe_Dauer_StdMin.Visible = True
        Case Else
            Me.Dauer_Bezeichnungsfeld.Caption = "Minuten"
            Me.Dauer_Minuten.Visible = True
            Me.Summe_Dauer_Minuten.Visible = True
    End Select
    
    'merken fr Bearbeitung
    AktTermin = Me.lfd_Nr.Value
    
End Sub

Private Sub Form_Open(Cancel As Integer)
    'aktuelles Whrungsformat des Systems einstellen
    Me.Re_Netto.Format = "Currency"
    Me.Su_Kalkulation.Format = "Currency"
End Sub

Private Sub Button_TerminInOutlookOeffnen_Click()
    OutlookElementOeffnen Me.Termin_ID
End Sub
